<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;
use Users\Model\Entities\User;

#[ORM\Table('eshop_orders__order_expedition_log')]
#[ORM\Entity]
class OrderExpeditionLog
{
	use TId;

	#[ORM\JoinColumn(name: 'order_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Order::class)]
	protected Order $order;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $service;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $status;

	#[ORM\Column(type: Types::TEXT, nullable: false)]
	public string $message;

	#[ORM\Column(name: 'created', type: Types::DATETIME_MUTABLE, options: ['default' => 'CURRENT_TIMESTAMP'])]
	protected \DateTime $created;

	#[ORM\JoinColumn(name: 'created_by', referencedColumnName: 'id', onDelete: 'SET NULL')]
	#[ORM\ManyToOne(targetEntity: User::class)]
	protected ?User $createdBy = null;

	public function __construct(Order $order, string $service, string $status, string $message, ?User $createdBy = null)
	{
		$this->order     = $order;
		$this->service   = $service;
		$this->status    = $status;
		$this->message   = $message;
		$this->createdBy = $createdBy;
		$this->created   = new DateTime;
	}

	public function getOrder(): Order { return $this->order; }

	public function getCreated(): \DateTime { return $this->created; }

	public function getCreatedBy(): ?User { return $this->createdBy; }
}
