<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;
use EshopOrders\Model\Entities\Attributes\IsReadyToDelivery;

#[ORM\Table('eshop_orders__order_gift')]
#[ORM\Entity]
class OrderGift implements IOrderItem
{
	use TId;
	use IsReadyToDelivery;

	#[ORM\JoinColumn(name: 'order_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Order::class, inversedBy: 'gifts')]
	protected Order $order;

	#[ORM\JoinColumn(name: 'product_id', referencedColumnName: 'id', onDelete: 'SET NULL')]
	#[ORM\ManyToOne(targetEntity: Product::class)]
	protected ?Product $product = null;

	#[ORM\Column(name: 'code1', type: Types::STRING, length: 60, nullable: true)]
	public ?string $code1 = null;

	#[ORM\Column(name: 'ean', type: Types::STRING, length: 20, nullable: true)]
	public ?string $ean = null;

	#[ORM\Column(name: 'name', type: Types::STRING, nullable: false)]
	public string $name;

	public function __construct(Order $order, Product $product, string $name)
	{
		$this->order   = $order;
		$this->product = $product;
		$this->name    = $name;
		$order->addGift($this);
	}

	public function getOrder(): Order { return $this->order; }

	public function getName(): string { return $this->name; }

	public function getProduct(): ?Product { return $this->product; }

	public function getProductId(): ?int { return $this->product ? $this->product->getId() : null; }

	public function getQuantity(): int { return 1; }

	public function getDefaultQuantity(): int { return $this->getQuantity(); }
}
