<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

#[ORM\Table('eshop_orders__order_paid_history')]
#[ORM\Entity]
class OrderPaidHistory
{
	use TId;

	#[ORM\JoinColumn(name: 'order_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Order::class, inversedBy: 'payment')]
	public Order $order;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $text;

	#[ORM\Column(name: 'created', type: Types::DATETIME_MUTABLE)]
	public \DateTime $created;

	#[ORM\Column(type: Types::SMALLINT, options: ['default' => 0])]
	public int $isDeleted = 0;

	public function __construct(Order $order, string $text)
	{
		$this->created = new DateTime;
		$this->order   = $order;
		$this->text    = $text;
	}

	public function getCreated(): \DateTime { return $this->created; }
}
