<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;
use Users\Model\Entities\User;

#[ORM\Table('eshop_orders__order_status_history')]
#[ORM\Entity]
class OrderStatusHistory implements IOrderStatus
{
	use TId;

	#[ORM\JoinColumn(name: 'order_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Order::class)]
	protected Order $order;

	#[ORM\JoinColumn(name: 'status_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Status::class)]
	protected Status $status;

	#[ORM\Column(name: 'created', type: Types::DATETIME_MUTABLE)]
	protected \DateTime $created;

	#[ORM\JoinColumn(name: 'created_by', referencedColumnName: 'id', onDelete: 'SET NULL')]
	#[ORM\ManyToOne(targetEntity: User::class)]
	protected ?User $createdBy = null;

	public function __construct(Order $order, Status $status, ?User $createdBy = null)
	{
		$this->order     = $order;
		$this->status    = $status;
		$this->createdBy = $createdBy;
		$this->created   = new DateTime;
	}

	public function getOrder(): Order { return $this->order; }

	public function getStatus(): Status { return $this->status; }

	public function getCreated(): \DateTime { return $this->created; }

	public function getCreatedBy(): ?User { return $this->createdBy; }
}
