<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use DateTime;
use Core\Model\Entities\Country;
use Core\Model\Entities\Site;
use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table('eshop_orders__payment_spedition')]
#[ORM\Entity]
class PaymentSpedition
{
	use TId;

	#[ORM\JoinColumn(name: 'payment_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Payment::class)]
	protected Payment $payment;

	#[ORM\JoinColumn(name: 'spedition_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Spedition::class)]
	protected Spedition $spedition;

	#[ORM\Column(name: 'is_published', type: Types::SMALLINT)]
	public int $isPublished = 0;

	/** @Gedmo\SortablePosition */
	#[ORM\Column(name: 'position', type: Types::INTEGER)]
	protected int $position = 0;

	/** @var Collection<Site> */
	#[ORM\JoinTable(name: 'eshop_orders__payment_spedition_site')]
	#[ORM\JoinColumn(name: 'ps_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\InverseJoinColumn(name: 'site_id', referencedColumnName: 'ident', onDelete: 'CASCADE')]
	#[ORM\ManyToMany(targetEntity: Site::class, indexBy: 'ident')]
	public Collection $sites;

	/** @var Collection<Country> */
	#[ORM\JoinTable(name: 'eshop_orders__payment_spedition_country')]
	#[ORM\JoinColumn(name: 'ps_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\InverseJoinColumn(name: 'country_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToMany(targetEntity: Country::class, indexBy: 'id')]
	public Collection $countries;

	/** @var Collection<GroupCustomers> */
	#[ORM\JoinTable(name: 'eshop_orders__payment_spedition_customer_group')]
	#[ORM\JoinColumn(name: 'ps_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\InverseJoinColumn(name: 'group_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToMany(targetEntity: GroupCustomers::class, indexBy: 'id')]
	public Collection $customerGroups;

	#[ORM\Column(name: 'customer_without_group', type: Types::SMALLINT, options: ['unsigned' => true, 'default' => 0])]
	public int $customerWithoutGroup = 0;

	#[ORM\Column(name: 'no_customer', type: Types::SMALLINT, options: ['unsigned' => true, 'default' => 0])]
	public int $noCustomer = 0;

	#[ORM\Column(name: 'currency', type: Types::STRING, nullable: true)]
	public ?string $currency = null;

	#[ORM\Column(name: 'free_from_date', type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTime $freeFromDate = null;

	#[ORM\Column(name: 'free_to_date', type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTime $freeToDate = null;

	public function __construct()
	{
		$this->isPublished = 1;
		$this->setPosition(-1);
		$this->countries      = new ArrayCollection();
		$this->sites          = new ArrayCollection();
		$this->customerGroups = new ArrayCollection();
	}

	public function getPayment(): Payment { return $this->payment; }

	public function setPayment(Payment $payment): PaymentSpedition
	{
		$this->payment = $payment;

		return $this;
	}

	public function getSpedition(): Spedition { return $this->spedition; }

	public function setSpedition(Spedition $spedition): PaymentSpedition
	{
		$this->spedition = $spedition;

		return $this;
	}

	public function getPosition(): int { return $this->position; }

	public function setPosition(int $position): PaymentSpedition
	{
		$this->position = $position;

		return $this;
	}
}
