<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Helpers\Strings;
use DateTimeInterface;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_orders__spedition_price_level')]
#[ORM\Entity]
class SpeditionPriceLevel
{

	#[ORM\JoinColumn(name: 'spedition_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Spedition::class, cascade: ['persist', 'remove'], inversedBy: 'priceLevels')]
	private Spedition $spedition;

	#[ORM\JoinColumn(name: 'group_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: GroupCustomers::class)]
	private GroupCustomers $group;

	/**
	 * @var float|string
	 */
	#[ORM\Column(name: 'price', type: Types::DECIMAL, precision: 10, scale: 2, nullable: false)]
	protected $price;

	#[ORM\Column(name: 'free_from', type: Types::INTEGER, nullable: true)]
	public ?int $freeFrom = null;

	#[ORM\Column(name: 'available_from', type: Types::INTEGER, nullable: true)]
	public ?int $availableFrom = null;

	#[ORM\Column(name: 'available_to', type: Types::INTEGER, nullable: true)]
	public ?int $availableTo = null;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTimeInterface $freeFromDate = null;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTimeInterface $freeToDate = null;

	public function __construct(Spedition $spedition, GroupCustomers $group, float $price)
	{
		$this->spedition = $spedition;
		$this->group     = $group;
		$this->setPrice($price);
	}

	public function getSpedition(): Spedition { return $this->spedition; }

	public function getGroup(): GroupCustomers { return $this->group; }

	public function getPrice(): float { return (float) $this->price; }

	public function setPrice(float $price): void
	{
		$this->price = (string) Strings::formatEntityDecimal($price);
	}
}
