<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Helpers\Strings;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_orders__spedition_weight')]
#[ORM\Entity]
class SpeditionWeight
{
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Spedition::class)]
	public Spedition $spedition;

	/**
	 * @var float|string
	 */
	#[ORM\Id]
	#[ORM\Column(name: 'weight_from', type: Types::DECIMAL, precision: 10, scale: 2, nullable: false, options: ['unsigned' => true])]
	protected $weightFrom;

	/**
	 * @var float|string
	 */
	#[ORM\Column(name: 'price', type: Types::DECIMAL, precision: 10, scale: 2, nullable: false, options: ['unsigned' => true])]
	protected $price;

	/**
	 * @param float|int|string $weightFrom
	 * @param float|int|string $price
	 */
	public function __construct(Spedition $spedition, $weightFrom, $price)
	{
		$this->spedition = $spedition;
		$this->setWeightFrom($weightFrom);
		$this->setPrice($price);
	}

	/** @param float|int|string $weightFrom */
	public function setWeightFrom($weightFrom): void { $this->weightFrom = (string) Strings::formatEntityDecimal($weightFrom); }

	public function getWeightFrom(): float { return (float) $this->weightFrom; }

	/** @param float|int|string $price */
	public function setPrice($price): void { $this->price = (string) Strings::formatEntityDecimal($price); }

	public function getPrice(): float { return (float) $this->price; }
}
