<?php declare(strict_types = 1);

namespace EshopOrders\Model\Helpers;

use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderPayment;
use EshopOrders\Model\Entities\OrderSpedition;

class OrderSpeditionHelper
{
	public function __construct(
		protected EntityManagerDecorator $em,
	)
	{
	}

	public function checkSpeditionVatRateByItemsPrice(Order $order): void
	{
		$maxPriceRate = null;
		$maxPrice     = 0;

		foreach ($order->getVatRates() as $rate => $prices) {
			if ($prices['total'] > $maxPrice) {
				$maxPrice     = $prices['total'];
				$maxPriceRate = (int) $rate;
			}
		}

		if ($order->getSpedition() instanceof OrderSpedition) {
			$order->getSpedition()->setVatRate($maxPriceRate);
			$this->em->persist($order->getSpedition());
		}

		if ($order->getPayment() instanceof OrderPayment) {
			$order->getPayment()->setVatRate($maxPriceRate);
			$this->em->persist($order->getPayment());
		}

		$this->em->flush();
	}
}
