<?php declare(strict_types = 1);

namespace EshopOrders\Model\Listeners;

use Core\Model\Event\EventDispatcher;
use Doctrine;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderStatus;
use EshopOrders\Model\Entities\OrderStatusHistory;
use EshopOrders\Model\Event\OrderStatusEvent;
use Nette\SmartObject;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Users\Model\Security\User;
use Users\Model\Users;

class OrderStatusListener implements EventSubscriberInterface
{
	use SmartObject;

	public function __construct(
		protected EventDispatcher $eventDispatcher,
		protected Users           $usersService,
		protected User            $user,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PreFlush]
	public function postUpdateHandler(OrderStatus $orderStatus, PreFlushEventArgs $event): void
	{
		foreach ($event->getObjectManager()->getUnitOfWork()->getScheduledEntityInsertions() as $entity) {
			if ($entity instanceof OrderStatus) {
				$this->eventDispatcher->dispatch(new OrderStatusEvent($entity->getOrder(), $entity->getStatus()->getId()), Order::class . '::changeStatus');
			}
		}
	}

	#[ORM\PostRemove]
	public function postRemoveHandler(OrderStatus $orderStatus, LifecycleEventArgs $events): void
	{
		$em      = $events->getObjectManager();
		$userRef = $this->usersService->getReference($this->user->getIdentity()->getId());
		$e       = new OrderStatusHistory($orderStatus->getOrder(), $orderStatus->getStatus(), $userRef);
		$em->persist($e);
		$em->flush();
	}
}
