<?php declare(strict_types = 1);

namespace EshopOrders\Model;

use Core\Model\Entities\EntityManagerDecorator;
use EshopCatalog\FrontModule\Model\Dao\Seller;
use EshopCatalog\FrontModule\Model\Sellers;
use EshopOrders\Model\Entities\InvoiceConfig;
use EshopOrders\Model\Entities\Order;

class Receipts
{
	public function __construct(
		protected EntityManagerDecorator  $em,
		protected Sellers                 $sellers,
		protected InvoiceConfigRepository $invoiceConfigRepository,
	)
	{
	}

	public function generateIdent(Order $order): string
	{
		/** @var Seller $seller */
		$seller   = $this->sellers->getSellerForSite($order->site->getIdent());
		$sellerId = $seller->id;
		$ident    = $this->invoiceConfigRepository->generateIdent($order, $sellerId, InvoiceConfig::TYPE_RECEIPT);
		$config   = $this->invoiceConfigRepository->getConfigBySeller($sellerId);

		$numericalSeries = $config->receiptNumericalSeries;
		$numericalSeries->increaseStartNumber();

		$this->em->persist($numericalSeries);

		return $ident;
	}

}
