<?php declare(strict_types = 1);

namespace EshopOrders\Model\Templating\Filters;

use EshopOrders\Model\Entities\IDiscount;
use EshopOrders\Model\Utils\Helpers;

class DiscountFilter
{
	public function __construct(
		protected Helpers $helpers,
	)
	{
	}

	public function __invoke(IDiscount $discount): string
	{
		return $this->helpers->formatDiscount($discount);
	}

}
