<?php declare(strict_types = 1);

namespace EshopOrders\Model\Utils;

class Strings extends \Nette\Utils\Strings
{
	/**
	 * @param string[] $needles
	 * @param bool     $containAll If $haystack must contain all $needles
	 */
	public static function containsMore(string $haystack, array $needles, bool $containAll = false): bool
	{
		if ($needles === []) {
			return false;
		}

		$result = 0;
		foreach ($needles as $needle) {
			if (\str_contains($haystack, $needle)) {

				if (!$containAll) {
					return true;
				}

				$result++;
			}
		}

		return $result === count($needles);
	}

}
