<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\DashboardWidgets;

use Core\Model\Helpers\Strings;
use Dashboard\AdminModule\Model\Provider\IWidget;
use EshopOrders\AdminModule\Model\Statistics;
use Nette\Utils\DateTime;

class MonthlyOrders extends BaseEshopOrdersWidget implements IWidget
{
	protected string $gridSize = 'col-md-8 col-xxl-6';

	protected string $key = 'eshopOrdersMonthlyOrders';

	public function __construct(
		protected Statistics\Statistics $statistics,
	)
	{
	}

	public function render(): void
	{
		$this['grid'];
		$file = $this->statistics->getMonthlyFile();

		if ($file) {
			$date = new DateTime();
			$date->setTimestamp(filemtime($file));
			$this->template->lastUpdate = $date;
		}

		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$grid->setDataSource($this->statistics->getMonthly(true));

		$grid->addColumnDateTime('date', 'eshopOrders.dashboardWidget.monthlyOrders.date')->setFormat('Y-m');
		$grid->addColumnNumber('orders', 'eshopOrders.dashboardWidget.monthlyOrders.ordersCount')
			->setFormat(0, '', ' ');
		$grid->addColumnNumber('ordersPrice', 'eshopOrders.dashboardWidget.monthlyOrders.ordersPrice')
			->setRenderer(function(array $row) {
				Strings::$priceKeepTail = true;

				return $this->priceFilter->format((float) $row['ordersPrice']);
			});
		Strings::$priceKeepTail = false;

		return $grid;
	}
}
