<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use EshopOrders\Model\CarriersHistory;
use EshopOrders\Model\Entities\CarrierHistory;
use EshopOrders\Model\Entities\Order;
use Nette\Utils\Html;

class CarrierHistoryGrid extends BaseControl
{
	public function __construct(protected Order $order, protected CarriersHistory $carriersHistory)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();

		$qb = $this->carriersHistory->getEr()->createQueryBuilder('ch');
		$qb->andWhere($qb->expr()->eq('ch.order', $this->order->getId()));

		$grid->setDataSource($qb)
			->setDefaultSort(['created' => 'asc'], true)
			->setPagination(false);

		$grid->addColumnText('speditionName', 'eshopOrders.carrierHistoryGrid.speditionName');
		$grid->addColumnText('numberPackage', 'eshopOrders.carrierHistoryGrid.numberPackage')
			->setTemplateEscaping(false)
			->setRenderer(function(CarrierHistory $ch) {
				if ($ch->numberPackage !== null) {
					return $ch->numberPackage;
				} else {
					return Html::el('i')->setText($this->t('eshopOrders.carrierHistoryGrid.numberPackageNotFilled'));
				}
			});
		$grid->addColumnDateTime('created', 'eshopOrders.carrierHistoryGrid.created')
			->setFormat('d.m.Y H:i:s');


		return $grid;
	}
}
