<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Orders;
use Nette\Utils\ArrayHash;

class CustomerInfoForm extends BaseControl
{
	public function __construct(protected Order $order, protected Orders $ordersService)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ======================== Setters
	 */

	/*******************************************************************************************************************
	 * ======================== Components
	 */

	protected function createComponentForm()
	{
		$form = $this->createForm();
		$form->setShowLangSwitcher(false);
		$form->setAjax();

		$form->addText('subject', 'eshopOrders.customerInfoForm.subject');
		$form->addTextArea('message', 'eshopOrders.customerInfoForm.message')->setRequired();

		$form->addSubmit('send', 'eshopOrders.customerInfoForm.send');
		$form->onSuccess[] = $this->formSuccess(...);

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		if ($this->ordersService->sendInfo($this->order, (string) $values->subject, $values->message)) {
			$this->getPresenter()->flashMessageSuccess('eshopOrders.customerInfoForm.emailSent');
		} else {
			$this->getPresenter()->flashMessageDanger('eshopOrders.customerInfoForm.emailError');
		}
		$this->getPresenter()->redrawControl('flashes');

		return true;
	}
}
