<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Contributte\Scheduler\Helpers\Debugger;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\Model\Entities\InvoiceConfig;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Invoices;
use Exception;
use Nette\Utils\ArrayHash;

class UploadExternalInvoice extends BaseControl
{
	public function __construct(protected Order $order, protected Invoices $invoices)
	{
	}

	public function render(): void
	{
		$this->template->order = $this->order;
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax()
			->setShowLangSwitcher(false);

		$form->addFilesManager('invoice', 'eshopOrders.uploadExternalInvoiceForm.invoice')
			->setDefaultValue($this->order->getInvoice() ? $this->order->getInvoice()->getExternalInvoiceFile() : null)
			->setRequired();

		$form->addSaveCancelControl();
		unset($form['saveControl']['save']);

		$form->onSuccess[] = function(BaseForm $form, ArrayHash $values) {
			try {
				$this->em->beginTransaction();

				$invoice = $this->invoices->getOneByOrder($this->order, true, InvoiceConfig::TYPE_INVOICE_EXTERNAL);
				$invoice->setExternalInvoiceFile($values->invoice);

				$this->em->persist($invoice);
				$this->em->flush($invoice);
				$this->em->commit();
			} catch (Exception $exception) {
				$this->em->rollback();
				Debugger::log($exception);
			}

			$this->presenter->redirect('this');
		};

		return $form;
	}
}
