<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Statuses;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\AdminModule\Model\Statuses;
use EshopOrders\Model\Entities\Status;
use EshopOrders\Model\Entities\StatusText;
use Exception;
use Nette\Utils\ArrayHash;

class StatusForm extends BaseControl
{
	/** @var string|null @persistent */
	public ?string $ident = null;

	public ?Status $status = null;

	public function __construct(protected Statuses $statuses)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addText('id', 'eshopOrders.status.id')
			->setMaxLength(255);
		$form->addText('name', 'eshopOrders.status.name')
			->setIsMultilanguage()
			->setMaxLength(255);
		$form->addBool('sendToCustomer', 'eshopOrders.status.sendToCustomer')
			->setDefaultValue(1);

		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = $this->formSuccess(...);

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		try {
			$langValues = $form->convertMultilangValuesToArray();
			/** @var StatusText[] $texts */

			if ($this->ident) {
				$status       = $this->statuses->get($this->ident);
				$flashMessage = 'eshopOrders.status.created';
				$texts        = $status->texts->toArray();
			} else {
				$status           = new Status($values->id);
				$status->isLocked = 0;
				$texts            = [];
				$flashMessage     = 'eshopOrders.status.edited';
			}

			$status->sendToCustomer = (int) $values->sendToCustomer;

			$this->em->persist($status);

			foreach ($langValues as $l => $v) {
				if ($v['name'] === '') {
					if (isset($texts[$l])) {
						$this->em->remove($texts[$l]);
						unset($texts[$l]);
					}

					continue;
				}

				if (!$texts[$l]) {
					$texts[$l] = new StatusText($status, $l);
				}
				$texts[$l]->name = $v['name'];

				$this->em->persist($texts[$l]);
				$status->texts->set($l, $texts[$l]);
			}

			$this->em->flush();

			$form->addCustomData('statusId', $status->getId());
			$this->getPresenter()->flashMessageSuccess($flashMessage);

			return true;
		} catch (Exception $e) {
			$form->addError($e->getMessage());
			$this->redrawControl('form');
		}

		return false;
	}

	public function setStatus($ident): void
	{
		$this->ident  = $ident;
		$this->status = $status = $this->statuses->get($ident);

		if (!$status) {
			$this->error();
		}

		$this['form']['id']->setDisabled();

		$d = [
			'id'             => $status->getId(),
			'sendToCustomer' => $status->sendToCustomer,
		];

		foreach ($status->texts as $v) {
			$d['name'][$v->getLang()] = $v->name;
		}

		$this['form']->setDefaults($d);
	}
}
