<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\ORM\Query\Expr\Join;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopOrders\Model\Entities\Cart;
use EshopOrders\Model\Entities\CartItem;
use Nette\Utils\DateTime;
use Nette\Utils\FileSystem;
use Tracy\Debugger;

class Carts
{
	public function __construct(protected EntityManagerDecorator $em, protected CacheService $cacheService)
	{
	}

	public function removeInactive(): void
	{
		Debugger::log('Carts - removeInactive', 'scheduler/' . (new DateTime())->format('y-m-d'));
		$date = (new DateTime())->modify('-14 days')->setTime(0, 0, 0);

		foreach ($this->em->createQueryBuilder()->select('ci.id')
			         ->from(CartItem::class, 'ci')
			         ->innerJoin('ci.cart', 'c', Join::WITH, 'c.lastActivity <= :date')
			         ->setParameter('date', $date)
			         ->getQuery()->getArrayResult() as $row) {
			FileSystem::delete(UPLOADS_DIR . DS . 'eshoporders-cart-uploads' . DS . $row['id']);
		}

		$this->em->createQueryBuilder()->delete(Cart::class, 'c')
			->where('c.lastActivity <= :date')
			->setParameter('date', $date)
			->getQuery()->execute();
	}
}
