<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\Model\Invoices;
use EshopOrders\Model\Pdf\IInvoicePdfBuilderFactory;
use Mpdf\MpdfException;
use Nette\Application\BadRequestException;
use Nette\DI\Attributes\Inject;

abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{
	#[Inject]
	public Invoices $invoices;

	#[Inject]
	public IInvoicePdfBuilderFactory $invoicePdfBuilderFactory;

	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access'))
			$this->error();
	}

	/**
	 *
	 * @throws BadRequestException
	 * @throws MpdfException
	 */
	public function handlePdf(mixed $id): void
	{
		$invoice = $this->invoices->get((int) $id);

		if ($invoice === null) {
			$this->error();
		}

		$this->invoicePdfBuilderFactory->create($invoice)->render();
	}

	public function handleRegenerate(int $invoiceId)
	{
		if ($this->invoices->regenerateInvoice($invoiceId))
			$this->flashMessageSuccess('eshopOrders.invoice.regenerated');
		else
			$this->flashMessageDanger('default.error');

		$this->redrawControl('flashes');
	}
}
