<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use EshopOrders\AdminModule\Components\Invoice\IInvoiceConfigFormFactory;
use EshopOrders\AdminModule\Components\Invoice\IInvoiceConfigsGridFactory;
use EshopOrders\AdminModule\Components\Invoice\InvoiceConfigForm;
use EshopOrders\AdminModule\Components\Invoice\InvoiceConfigsGrid;
use EshopOrders\Model\InvoiceConfigRepository;
use Exception;
use Nette\Application\UI\InvalidLinkException;
use Nette\Utils\ArrayHash;

class InvoiceConfigsPresenter extends BasePresenter
{
	/** @var InvoiceConfigRepository @inject */
	public $invoiceConfigRepository;

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	/**
	 * @throws InvalidLinkException
	 */
	public function actionDefault(): void
	{
		$navigation = [];
		$this->setHeader('eshopOrders.title.invoiceSettings', 'fas fa-cogs');

		// invoice settings navigation item
		$navigation[] = [
			'title' => 'eshopOrders.menu.addInvoiceSettings',
			'link'  => $this->link('invoiceSettings!'),
			'ico'   => 'fas fa-plus',
			'class' => 'ajax',
		];

		$this['navigation']->setData(['header' => $navigation]);
	}

	/*******************************************************************************************************************
	 * ============================== Signals
	 */

	/**
	 * @param $itemId
	 *
	 * @throws Exception
	 */
	public function handleInvoiceSettings($itemId): void
	{
		if (!$itemId && $this->invoiceConfigRepository->haveAllSellersInvoiceSettingsCreated()) {
			$this->flashMessageWarning(
				'eshopOrders.invoiceConfigForm.numericalSeries.warnings.allSitesHaveInvoiceSettingsCreated',
			);
			$this->redrawControl('flashes');

			return;
		}

		if ($itemId) {
			$this['invoiceConfigForm']->setDefaults();
		}

		$this->template->modalTitle = $this->t('eshopOrders.title.invoiceSettings');
		$this->redrawControl('modal');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */
	public function createComponentInvoiceConfigForm(IInvoiceConfigFormFactory $factory): InvoiceConfigForm
	{
		$itemId = $this->getParameter('itemId');
		$form   = $factory->create($itemId ? ((int) $itemId) : null);

		$form['form']->onSuccess[] = function(BaseForm $form, ArrayHash $arrayHash) {
			$this['invoiceConfigsGrid']['grid']->reload();
		};

		return $form;
	}

	public function createComponentInvoiceConfigsGrid(IInvoiceConfigsGridFactory $factory): InvoiceConfigsGrid
	{
		return $factory->create();
	}

}
