<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\AdminModule\Components\Invoice\IInvoicesGridFactory;
use EshopOrders\AdminModule\Components\Invoice\InvoicesGrid;
use EshopOrders\AdminModule\Model\Event\InvoiceRegenerateEvent;
use Nette\Application\UI\InvalidLinkException;

class InvoicePresenter extends BasePresenter
{
	protected function startup(): void
	{
		parent::startup();
		$this->eventDispatcher->addListener('eshopOrders.afterSaveRegeneratedInvoice', function(
			InvoiceRegenerateEvent $event,
		) {
			$this['invoicesGrid']['grid']->reload();
		});
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	/**
	 * @throws InvalidLinkException
	 */
	public function actionDefault(): void
	{
		$navigation = [];
		$this->setHeader('eshopOrders.title.invoices', 'fa fa-shopping-cart');

		// invoice settings navigation item
		$navigation[] = [
			'title' => 'eshopOrders.menu.invoiceSettings',
			'link'  => $this->link('InvoiceConfigs:default'),
			'ico'   => 'fas fa-cogs',
		];

		$this['navigation']->setData(['header' => $navigation]);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */
	public function createComponentInvoicesGrid(IInvoicesGridFactory $factory): InvoicesGrid
	{
		return $factory->create();
	}

}
