<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\AdminModule\Components\Payment\IPaymentsGridFactory;
use EshopOrders\AdminModule\Components\Payment\PaymentsGrid;
use EshopOrders\AdminModule\Components\PaymentSpedition\IPaymentSpeditionsGridFactory;
use EshopOrders\AdminModule\Components\PaymentSpedition\PaymentSpeditionsGrid;
use EshopOrders\AdminModule\Components\Spedition\ISpeditionsGridFactory;
use EshopOrders\AdminModule\Components\Spedition\SpeditionsGrid;

class PaymentSpeditionPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this->setHeader('eshopOrders.menu.paymentSpedition', 'fa fa-truck');
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopOrders.menu.addPayment',
				'link'  => $this->link('paymentsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			], [
				'title' => 'eshopOrders.menu.addSpedition',
				'link'  => $this->link('speditionsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			], [
				'title' => 'eshopOrders.menu.addPaymentSpedition',
				'link'  => $this->link('paymentSpeditionsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentPaymentsGrid(IPaymentsGridFactory $factory): PaymentsGrid
	{
		return $factory->create();
	}

	protected function createComponentSpeditionsGrid(ISpeditionsGridFactory $factory): SpeditionsGrid
	{
		return $factory->create();
	}

	protected function createComponentPaymentSpeditionsGrid(IPaymentSpeditionsGridFactory $factory,
	): PaymentSpeditionsGrid
	{
		return $factory->create();
	}
}
