<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\AdminModule\Components\ISettingsFormFactory;
use EshopOrders\AdminModule\Components\SettingsForm;
use EshopOrders\AdminModule\Components\Statuses\IStatusesGridFactory;
use EshopOrders\AdminModule\Components\Statuses\StatusesGrid;

class SettingsPresenter extends BasePresenter
{
	/*******************************************************************************************************************
	 * ==================================   Handle
	 */

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault(): void
	{
		$this->setHeader('eshopOrders.title.ordersSettings', 'fas fa-cogs');

		//		$this['navigation']->setData(['header' => [
		//			[
		//				'title' => 'eshopCatalog.menu.addVatRate',
		//				'link'  => $this->link('vatRatesGrid:add!'),
		//				'ico'   => 'plus',
		//				'class' => 'ajax',
		//			]
		//		]]);
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentStatusesGrid(IStatusesGridFactory $factory): StatusesGrid
	{
		return $factory->create();
	}

	protected function createComponentSettingsForm(ISettingsFormFactory $factory): SettingsForm
	{
		return $factory->create('eshopOrders');
	}
}

