<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Annotation\Controller\RequestBody;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Apitte\Negotiation\Http\ArrayEntity;
use EshopOrders\ApiModule\Api\V1\BodyEntity\CartItem;
use EshopOrders\FrontModule\Model\CartFacade;
use EshopOrders\FrontModule\Model\CartHelper;
use EshopOrders\FrontModule\Model\Dao\AddOrUpdateItem;

/**
 * @Path("/cart")
 */
class CartController extends BaseController
{
	public function __construct(protected CartFacade $cartFacade, protected CartHelper $cartHelper)
	{
	}

	/**
	 * @Path("/item")
	 * @Method("POST")
	 * @RequestBody(entity="EshopOrders\ApiModule\Api\V1\BodyEntity\CartItem")
	 */
	public function addItem(ApiRequest $request, ApiResponse $response)
	{
		error_reporting(~E_USER_DEPRECATED & ~E_WARNING & ~E_NOTICE & ~E_USER_WARNING & ~E_USER_NOTICE);

		/** @var CartItem $data */
		$data = $request->getEntity();

		$addOrUpdateItem            = new AddOrUpdateItem(
			$data->itemId,
			$data->name,
			$data->price,
		);
		$addOrUpdateItem->productId = $data->productId;
		$addOrUpdateItem->quantity  = $data->quantity;
		$addOrUpdateItem->moreData  = $data->moreData;
		$addOrUpdateItem->note      = $data->note;
		$addOrUpdateItem->files     = $data->files;
		$addOrUpdateItem->image     = $data->image;

		$cartItem = $this->cartFacade->addOrUpdateItem($addOrUpdateItem);

		$result = [
			'cartItem' => (array) $cartItem,
		];

		$cart = $this->cartFacade->getCartsService()->getCurrentCart();
		if ($cart) {
			$itemsCount = $cart->getItemsCount();

			$result['ajaxPlaceholders'] = [
				'cartPreviewItemsCount'    => (string) $this->cartHelper->getItemsCountFormatted($itemsCount),
				'cartPreviewItemsCountRaw' => $itemsCount,
				'cartPreviewItemsPrice'    => (string) $this->cartHelper->getPriceFormatted(
					$cart->getCartItemsPrice(true),
					$cart->getCartItemsPrice(false),
				),
			];
		}

		if ($cartItem) {
			if ($data->files) {
				$this->cartHelper->uploadFiles($cartItem, $data->files);
			}

			return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from($result));
		}

		return $response->withStatus(ApiResponse::S500_INTERNAL_SERVER_ERROR);
	}
}
