<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Annotation\Controller\RequestParameter;
use Apitte\Core\Annotation\Controller\RequestParameters;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Apitte\Negotiation\Http\ArrayEntity;
use EshopOrders\ApiModule\Api\V1\Model\CustomerGroups;

/**
 * @Path("/customer-groups")
 */
class CustomerGroupsController extends BaseController
{
	public function __construct(protected CustomerGroups $customerGroups)
	{
	}

	/**
	 * @Path("/")
	 * @Method("GET")
	 */
	public function index(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		return $response->withStatus(ApiResponse::S200_OK)
			->withEntity(ArrayEntity::from($this->customerGroups->getAll()));
	}

	/**
	 * @Path("/{group}/param")
	 * @Method("POST")
	 * @RequestParameters({
	 *      @RequestParameter(name="group", type="int", required=true),
	 * })
	 */
	public function setParam(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		$body  = $request->getJsonBody();
		$key   = $body['key'];
		$value = $body['value'];

		if ($key && $value) {
			$result = $this->customerGroups->setParameter(
				$request->getParameter('group'),
				(string) $key,
				(string) $value,
			);
		} else {
			$result = null;
		}

		return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from(['result' => $result]));
	}
}
