<?php declare(strict_types = 1);

namespace EshopOrders\CronModule\Presenters;

use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\EshopOrdersConfig;
use EshopOrders\Model\Orders;
use Nette\DI\Attributes\Inject;

class DefaultPresenter extends BasePresenter
{
	#[Inject]
	public Orders $ordersService;

	#[Inject]
	public EntityManagerDecorator $em;

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionSendSurvey()
	{
		ini_set('memory_limit', '4g');
		$config    = EshopOrdersConfig::load('sendSurveyAfterOrder');
		$bulkLimit = EshopOrdersConfig::load('surveyBulkLimit') ?: 20;

		if ($config === false)
			$this->terminate();

		$qb       = $this->ordersService->getOrdersWithoutSurveySent($config, (int) $bulkLimit);
		$iterator = $qb->getQuery()->iterate();

		$i = 1;
		while (($row = $iterator->next()) !== false) {
			/** @var Order $order */
			$order = array_values($row)[0];
			$this->ordersService->sendSurvey($order);
			$i++;

			if ($i % 20 === 0) {
				$this->em->clear();
				gc_collect_cycles();
			}
		}

		$this->terminate();
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

}
