<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use Core\Model\Dao\Country;
use DateTimeInterface;
use Nette\Utils\DateTime;

class PaymentSpedition
{
	public ?DateTimeInterface $freeFromDate = null;

	public ?DateTimeInterface $freeToDate = null;

	/** @var Country[] */
	protected array $countries = [];

	public ?string $currency = null;

	public function __construct(protected int $id, protected Payment $payment, protected Spedition $spedition)
	{
	}

	public function getId(): int { return $this->id; }

	public function getPayment(): Payment { return $this->payment; }

	public function getSpedition(): Spedition { return $this->spedition; }

	/**
	 * @return array|Country[]
	 */
	public function getCountries(): array { return $this->countries; }

	public function setCountries(array $countries): void
	{
		$this->countries = $countries;
	}

	public function addCountry(string $key, Country $country): void
	{
		$this->countries[$key] = $country;
	}

	public function isFreeCombination()
	{
		$today = (new DateTime())->getTimestamp();

		return $this->freeFromDate && $today >= $this->freeFromDate->getTimestamp()
			&& (!$this->freeToDate || $today <= $this->freeToDate->getTimestamp());
	}
}
