<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;

class UpdatedCartItemEvent extends Event
{
	/** @var int */
	public $quantity;

	public function __construct(
		public       $itemId,
		int          $quantity,
		public int   $beforeQuantity,
		public array $moreData = [],
		public ?int  $productId = null,
	)
	{
		$this->quantity = $quantity;
	}
}
