<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Presenters;

use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\FrontModule\Components\OrderItemReviews\IOrderItemReviewFormFactory;
use EshopOrders\FrontModule\Components\OrderItemReviews\OrderItemReviewForm;
use EshopOrders\Model\Entities\OrderItem;
use EshopOrders\Model\Orders;
use Nette\Application\UI\Multiplier;

class OrderItemReviewsPresenter extends BasePresenter
{
	/** @var string|null @persistent */
	public ?string $orderIdent = null;

	/** @var Orders @inject */
	public $orders;

	/** @var EntityManagerDecorator @inject */
	public $em;

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionGiveReviews(): void
	{
		$orderIdent = $this->getParameter('orderIdent');

		if (!$orderIdent) {
			$this->error();
		}

		$this->orderIdent = $orderIdent;
		$order            = $this->orders->getByIdent($orderIdent);

		if (!$order) {
			$this->error();
		}

		$this->template->order = $order;
	}

	public function createComponentOrderItemReviewForm(IOrderItemReviewFormFactory $factory): Multiplier
	{
		return new Multiplier(function($orderItemId) use ($factory): OrderItemReviewForm {
			$control = $factory->create($this->em->getReference(OrderItem::class, (int) $orderItemId));

			return $control;
		});
	}

}
