<?php declare(strict_types = 1);

namespace EshopOrders\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200123200041 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql('ALTER TABLE eshop_orders__payment_spedition ADD site_id VARCHAR(255) DEFAULT NULL');
		$this->addSql(
			'ALTER TABLE eshop_orders__payment_spedition ADD CONSTRAINT FK_108548CBF6BD1646 FOREIGN KEY (site_id) REFERENCES core__site (ident) ON DELETE CASCADE',
		);
		$this->addSql('CREATE INDEX IDX_108548CBF6BD1646 ON eshop_orders__payment_spedition (site_id)');
	}

	public function postUp(Schema $schema): void
	{
		$sites = $this->connection->fetchAll("SELECT ident FROM core__site LIMIT 1");
		if ($sites[0]) {
			$this->connection->prepare("UPDATE eshop_orders__payment_spedition SET site_id = ?")
				->execute([$sites[0]['ident']]);
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql('ALTER TABLE eshop_orders__payment_spedition DROP FOREIGN KEY FK_108548CBF6BD1646');
		$this->addSql('DROP INDEX IDX_108548CBF6BD1646 ON eshop_orders__payment_spedition');
		$this->addSql('ALTER TABLE eshop_orders__payment_spedition DROP site_id');
	}
}
