<?php declare(strict_types = 1);

namespace EshopOrders\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200311124144 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql(
			'CREATE TABLE eshop_orders__payment_spedition_country (ps_id INT NOT NULL, country_id VARCHAR(255) NOT NULL, INDEX IDX_598E5A8DDF7A0482 (ps_id), INDEX IDX_598E5A8DF92F3E70 (country_id), PRIMARY KEY(ps_id, country_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'ALTER TABLE eshop_orders__payment_spedition_country ADD CONSTRAINT FK_598E5A8DDF7A0482 FOREIGN KEY (ps_id) REFERENCES eshop_orders__payment_spedition (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE eshop_orders__payment_spedition_country ADD CONSTRAINT FK_598E5A8DF92F3E70 FOREIGN KEY (country_id) REFERENCES core__country (id) ON DELETE CASCADE',
		);
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$stmt = $this->connection->prepare("SELECT id FROM core__country WHERE id = ?");
		$stmt->execute(['cz']);

		$countryId = $stmt->fetch();
		if ($countryId) {
			$countryId = $countryId['id'];
			$stmt      = $this->connection->prepare("SELECT id FROM eshop_orders__payment_spedition");
			$stmt->execute();

			foreach ($stmt->fetchAll() as $combination) {
				$this->connection->insert('eshop_orders__payment_spedition_country', [
					'ps_id'      => $combination['id'],
					'country_id' => $countryId,
				]);
			}
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql('DROP TABLE eshop_orders__payment_spedition_country');
	}
}
