<?php declare(strict_types = 1);

namespace EshopOrders\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20210823073444 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql('ALTER TABLE eshop_orders__invoice_address ADD country_code VARCHAR(2) DEFAULT NULL');
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$conn      = $this->connection;
		$countries = $conn->fetchAllAssociativeIndexed("SELECT name, id FROM core__country");

		foreach ($conn->fetchAllAssociative(
			"SELECT id, country FROM eshop_orders__invoice_address WHERE country_code IS NULL",
		) as $row) {
			if (!isset($countries[$row['country']]))
				continue;

			$conn->executeQuery(
				"UPDATE eshop_orders__invoice_address SET country_code = ? WHERE id = ?",
				[$countries[$row['country']]['id'],
					$row['id']],
			);
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql('ALTER TABLE eshop_orders__invoice_address DROP country_code');
	}
}
