<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Helpers\Strings;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_orders__group_customers')]
#[ORM\Entity]
class GroupCustomers
{
	use TId;

	/**
	 * @var string
	 */
	#[ORM\Column(name: 'short', type: 'string', length: 60)]
	public $short;

	/**
	 * @var string
	 */
	#[ORM\Column(name: 'name', type: 'string', length: 255)]
	public $name;

	/**
	 * @var int
	 */
	#[ORM\Column(name: 'is_published', type: 'smallint', length: 1)]
	public $isPublished;

	/**
	 * @var Customer[]
	 */
	#[ORM\OneToMany(targetEntity: 'Customer', mappedBy: 'groupCustomers', indexBy: 'id', cascade: ['all'])]
	protected $customers;

	/**
	 * @var float
	 */
	#[ORM\Column(name: 'products_sale', type: 'decimal', precision: 10, scale: 2, options: ['default' => 0], nullable: false)]
	protected $productsSale;

	/**
	 * @var ArrayCollection|GroupParam[]
	 */
	#[ORM\OneToMany(targetEntity: 'GroupParam', mappedBy: 'group', indexBy: 'key')]
	protected $params;

	#[ORM\Column(name: 'disable_measuring_codes', type: 'smallint', nullable: false, options: ['default' => 0])]
	public int $disableMeasuringCodes = 0;

	#[ORM\Column(name: 'products_sale_use_group_price', type: 'smallint', nullable: false, options: ['default' => 0])]
	public int $productsSaleUseGroupPrice = 0;

	#[ORM\ManyToOne(targetEntity: 'GroupCustomers')]
	#[ORM\JoinColumn(name: 'inherit_prices_group', referencedColumnName: 'id', onDelete: 'SET NULL', nullable: true)]
	public ?GroupCustomers $inheritPricesGroup = null;

	#[ORM\ManyToOne(targetEntity: 'GroupCustomers')]
	#[ORM\JoinColumn(name: 'use_products_sale_on_group', referencedColumnName: 'id', onDelete: 'SET NULL', nullable: true)]
	public ?GroupCustomers $useProductsSaleOnGroup = null;

	public function __construct(string $short, string $name)
	{
		$this->short        = $short;
		$this->name         = $name;
		$this->productsSale = 0;
		$this->customers    = new ArrayCollection();
		$this->params       = new ArrayCollection();
	}

	public function getProductsSale(): float { return (float) $this->productsSale; }

	public function setProductsSale($value): self
	{
		$this->productsSale = Strings::formatEntityDecimal($value);

		return $this;
	}

	/**
	 * @return ArrayCollection|GroupParam[]
	 */
	public function getParams() { return $this->params; }
}
