<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use DateTime;
use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table('eshop_orders__order_card_payment_history')]
#[ORM\Entity]
class OrderCardPaymentHistory
{
	use TId;

	const STATUS_CREATED   = 'created';
	const STATUS_CHECKOUT  = 'checkout';
	const STATUS_ERROR     = 'error';
	const STATUS_CANCELLED = 'cancelled';
	const STATUS_PAID      = 'paid';

	/**
	 * @var OrderCardPaymentToken
	 */
	#[ORM\ManyToOne(targetEntity: 'OrderCardPaymentToken')]
	#[ORM\JoinColumn(name: 'token_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public $token;

	/**
	 * @var string
	 */
	#[ORM\Column(name: 'status', type: 'string', length: 255, nullable: false)]
	protected $status;

	/**
	 * @var string
	 */
	#[ORM\Column(name: 'note', type: 'string', length: 255, nullable: true)]
	public $note;

	/**
	 * @var DateTime
	 */
	#[Gedmo\Timestampable(on: 'create')]
	#[ORM\Column(name: 'created', type: 'datetime')]
	private $created;

	public function __construct(OrderCardPaymentToken $token, string $status)
	{
		$this->token  = $token;
		$this->status = $status;
	}

	public function getStatus(): string { return $this->status; }

	public function getCreated(): DateTimeInterface { return $this->created; }
}
