<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_orders__order_flag')]
#[ORM\UniqueConstraint(name: 'order_flag_unique', columns: ['order_id', 'type'])]
#[ORM\Entity]
class OrderFlag
{
	const TYPE_QUESTIONING        = 'agreed_questioning';
	const TYPE_NEWSLETTER         = 'agreed_newsletter';
	const TYPE_INVOICE_SENT       = 'invoice_sent';
	const TYPE_SURVEY             = 'survey';
	const TYPE_REQUEST_FOR_REVIEW = 'request_for_review';

	use TId;

	/** druh priznaku (napr "agreed_questioning" - souhlas s dotaznikem spokojenosti)
	 * @var string
	 */
	#[ORM\Column(name: 'type', type: 'string')]
	protected $type;

	/**
	 * @var boolean
	 */
	#[ORM\Column(name: 'state', type: 'boolean', nullable: true)]
	protected $state;

	/**
	 * @var Order
	 */
	#[ORM\ManyToOne(targetEntity: 'Order', inversedBy: 'orderFlags', cascade: ['persist'])]
	#[ORM\JoinColumn(name: 'order_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public $order;

	public function __construct($type, $state, $order)
	{
		$this->type  = $type;
		$this->state = $state;
		$this->order = $order;
	}

	/*******
	 * === Type
	 */

	public function getType()
	{
		return $this->type;
	}

	public function setType($type): OrderFlag
	{
		$this->type = $type;

		return $this;
	}

	/*******
	 * === State
	 */

	public function getState()
	{
		return $this->state;
	}

	public function setState($state): OrderFlag
	{
		$this->type = $state;

		return $this;
	}

	/*******
	 * === Order
	 */

	public function getOrder(): Order
	{
		return $this->order;
	}

	public function setOrder(Order $order)
	{
		$this->order = $order;

		return $this;
	}
}

