<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;

#[ORM\Table('eshop_orders__order_item_gift')]
#[ORM\Entity]
class OrderItemGift implements IOrderItem
{
	use TId;

	/**
	 * @var OrderItem
	 */
	#[ORM\ManyToOne(targetEntity: 'OrderItem', inversedBy: 'gifts')]
	#[ORM\JoinColumn(name: 'order_item_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	protected $orderItem;

	/**
	 * @var Product
	 */
	#[ORM\ManyToOne(targetEntity: 'EshopCatalog\Model\Entities\Product')]
	#[ORM\JoinColumn(name: 'product_id', referencedColumnName: 'id', onDelete: 'SET NULL')]
	protected $product;

	/**
	 * @var string
	 */
	#[ORM\Column(name: 'code1', type: 'string', length: 60, nullable: true)]
	public $code1;

	/**
	 * @var string
	 */
	#[ORM\Column(name: 'ean', type: 'string', length: 20, nullable: true)]
	public $ean;

	/**
	 * @var string
	 */
	#[ORM\Column(name: 'name', type: 'string', nullable: false)]
	protected $name;

	public function __construct(OrderItem $orderItem, Product $product, string $name)
	{
		$this->orderItem = $orderItem;
		$this->product   = $product;
		$this->name      = $name;
		$orderItem->addGift($this);
	}

	public function getOrderItem(): OrderItem { return $this->orderItem; }

	public function getProduct(): ?Product { return $this->product; }

	public function getName(): string { return $this->name; }

	public function getQuantity(): int { return 1; }

	public function getOrder(): Order { return $this->getOrderItem()->getOrder(); }

	public function getProductId() { return $this->getProduct() ? $this->getProduct()->getId() : null; }

	public function getDefaultQuantity()
	{
		return $this->getQuantity();
	}
}
