<?php declare(strict_types = 1);

namespace EshopOrders\Model\Event;

use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderStatus;
use Nette\Application\UI\ITemplate;
use Nette\Mail\Message;
use Nette\Utils\Html;
use Symfony\Contracts\EventDispatcher\Event;

class EmailEvent extends Event
{
	public ITemplate $template;

	public Message $message;

	public function __construct(
		ITemplate           $template,
		Message             $message,
		public Order        $order,
		public ?string      $status = null,
		public ?OrderStatus $orderStatus = null,
	)
	{
		$this->template = &$template;
		$this->message  = &$message;
	}

	public function addCustomHtml(Html $html)
	{
		if (!isset($this->template->customHtml))
			$this->template->customHtml = Html::el('div');

		$this->template->customHtml->addHtml($html);
	}
}
