<?php declare(strict_types = 1);

namespace EshopOrders\Model\Helpers;

use EshopOrders\Model\EshopOrdersConfig;
use Nette\Utils\Floats;

class OrderItemReviewsHelper
{
	/*
	 * @return float[]
	 */
	public static function ratingToArray(float $value, bool $withBlanks = false): array
	{
		$result = [];
		for ($i = 0; $i < ((int) $value); $i++) {
			$result[] = 1;
		}

		// pulhvezdicka
		if (Floats::isGreaterThan(($value - (int) $value), 0)) {
			$result[] = 0.5;
		}

		// prazdne hvezdicky
		if ($withBlanks) {
			for ($i = 0, $count = count($result); $i < (EshopOrdersConfig::load(
					'orderItemReviews.maxRating',
				) - $count); $i++) {
				$result[] = 0;
			}
		}

		return $result;
	}
}
