<?php declare(strict_types = 1);

namespace EshopOrders\Model\Listeners;

use Core\Model\Event\Event;
use Core\Model\Event\EventDispatcher;
use Doctrine\ORM\Event\PrePersistEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Invoice;
use EshopOrders\Model\InvoiceConfigRepository;

class InvoiceListener
{
	public function __construct(
		protected InvoiceConfigRepository $invoiceConfigRepository,
		protected EventDispatcher         $eventDispatcher,
	)
	{
	}

	#[ORM\PrePersist]
	public function prePersist(Invoice $invoice, PrePersistEventArgs $event): void
	{
		$entityManager = $event->getObjectManager();

		$sellerId = $invoice->seller->getId();
		$event    = new Event(['order' => $invoice->order]);
		$this->eventDispatcher->dispatch($event, self::class . '::beforeIncreaseStartNumber');

		if (isset($event->data['seller']) && $event->data['seller'] !== null) {
			$sellerId = $event->data['seller']->getId();
		}

		$config = $this->invoiceConfigRepository->getConfigBySeller($sellerId);

		$numericalSeries = $invoice->order->isCorrectiveTaxDocument ? $config->correctiveNumericalSeries : $config->numericalSeries;
		$numericalSeries->increaseStartNumber();

		$entityManager->persist($numericalSeries);
		$entityManager->flush($numericalSeries);
	}
}
