<?php declare(strict_types = 1);

namespace EshopOrders\Model\Subscribers;

use Contributte\Events\Extra\Event\Application\StartupEvent;
use EshopOrders\FrontModule\Model\Customers;
use EshopOrders\Model\EshopOrdersConfig;
use MeasuringCodes\DI\MeasuringCodesExtension;
use MeasuringCodes\Model\MeasuringCodesConfig;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Users\Model\Security\User;

class ApplicationSubscriber implements EventSubscriberInterface
{
	public function __construct(protected User $user, protected Customers $customers)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [
			StartupEvent::class => 'onStartup',
		];
	}

	public function onStartup(StartupEvent $ev): void
	{
		if (class_exists(MeasuringCodesExtension::class) && EshopOrdersConfig::load(
				'customerGroup.allowDisableMeasuringCodes',
			) && $this->user->isLoggedIn()) {
			$customer = $this->customers->getByUser($this->user->getIdentity());

			if ($customer && $customer->getGroupCustomers() && $customer->getGroupCustomers()->disableMeasuringCodes) {
				MeasuringCodesConfig::setParam('enabled', false);
			}
		}
	}
}
