<?php declare(strict_types = 1);

namespace EshopOrders\Model\Subscribers;

use Core\Model\Event\TemplateFactoryEvent;
use EshopCatalog\Model\Config;
use EshopOrders\FrontModule\Model\CartFacade;
use EshopOrders\FrontModule\Model\Customers;
use EshopOrders\FrontModule\Model\Dao\Cart;
use EshopOrders\Model\Entities\Customer;
use EshopOrders\Model\EshopOrdersConfig;
use EshopPackages\Model\EshopPackagesConfig;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Users\Model\Security\User;

class TemplateSubscriber implements EventSubscriberInterface
{
	public static bool $loadData = true;

	protected static ?Customer $currentCustomer = null;

	protected $preparedTemplate = null;

	protected ?Cart $cart = null;

	protected $customer = null;

	protected bool $firstInited = false;

	public function __construct(protected Customers $customers, protected CartFacade $cartFacade, protected User $user)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'templateFactory::createTemplate' => 'createTemplate',
		];
	}

	protected function getCart(): Cart
	{
		if ($this->cart === null)
			$this->cart = $this->cartFacade->getCart();

		return $this->cart;
	}

	protected function getCustomer()
	{
		if ($this->customer === null) {
			if ($this->user->isLoggedIn()) {
				$this->customer = $this->customers->getByUser($this->user->getIdentity());
			} else {
				$this->customer = false;
			}
		}

		return $this->customer;
	}

	public function createTemplate(TemplateFactoryEvent $event): void
	{
		if (!self::$loadData) {
			return;
		}

		$event->template->cart     = $this->getCart();
		$customer                  = $this->getCustomer();
		$event->template->customer = $this->customer instanceof Customer ? $customer : null;

		if (!$this->firstInited && $customer) {
			if (EshopOrdersConfig::load('customer.allowShowPricesWithoutVat', false)
				&& isset($customer->getExtraFieldsValues()['showPricesWithoutVat']) && $customer->getExtraFieldsValues(
				)['showPricesWithoutVat'] === '1') {

				EshopOrdersConfig::addParams([
					'cartPreview.showPriceWithoutVat'      => true,
					'orderForm.showPriceWithoutVat'        => true,
					'speditions.showPriceWithoutVatInCart' => true,
					'payments.showPriceWithoutVatInCart'   => true,
					'emails.showPriceWithoutVat'           => true,
				]);

				if (class_exists(Config::class))
					Config::addParams([
						'productPreview.basePriceWithoutVat' => true,
						'productDetail.basePriceWithoutVat'  => true,
					]);

				if (class_exists(EshopPackagesConfig::class))
					EshopPackagesConfig::addParams([
						'showPricesWithoutVat' => true,
					]);
			}
		}

		$this->firstInited = true;
	}
}
