<?php declare(strict_types = 1);

namespace EshopOrders\Model\Utils;

use function str_contains;

class Strings extends \Nette\Utils\Strings
{
	/**
	 * @param string[] $needles
	 * @param bool     $containAll If $haystack must contain all $needles
	 */
	public static function containsMore(string $haystack, array $needles, bool $containAll = false): bool
	{
		if (count($needles) === 0) {
			return false;
		}

		$result = 0;
		foreach ($needles as $needle) {
			if (str_contains($haystack, $needle)) {

				if (!$containAll) {
					return true;
				}

				$result++;
			}
		}

		return $result === count($needles);
	}

}
