import {FormatMoney} from 'core/js/utils/formatMoney';
import tippy from "tippy.js";

export class AddToCartExtension {
	constructor(naja) {
		this.initCart();

		let popupTrigger = null;

		document.addEventListener('click', e => {
			const target = e.target;

			if (target.matches('.cart-add__submit')) {
				popupTrigger = target;
				if (target.dataset.customPopup !== undefined) {
					document.dispatchEvent(new CustomEvent('addToCartSubmitClick', {
						detail: {
							target   : target,
							popupData: target.dataset.customPopup,
						},
					}));
				} else if (target.classList.contains('is-assort')) {
					const wrap = target.closest('.cart-add');

					const modal = '<div class="darker darker--active darker--cart" data-only-once></div><div data-only-once class="cart-add__popup modal modal--active">\n' +
					              ' <div class="modal__inner">' +
					              '  <div class="modal__header primary-bg-color">\n' +
					              '   <span>' + window.cmsTexts.cartAddFormAssortPopupTitle + '</span>\n' +
					              '   <div class="modal__close"></div>\n' +
					              '  </div>\n' +
					              '  <div class="modal__body-wrap">\n' +
					              '   <div class="modal__body">\n' +
					              '      <div class="cart-add__popup-frm-pair">' +
					              '        <label>' + window.cmsTexts.eshopCatalogNote + '</label>' +
					              '        <textarea data-target="' + wrap.querySelector('[name="note"]').id + '" class="cart-add__note-popup-placeholder" placeholder="' + window.cmsTexts.eshopCatalogAssortPlaceholder + '"></textarea>' +
					              '      </div>' +
					              '      <div class="cart-add__note-popup-buttons">' +
					              '        <button class="btn secondary-bg-color" data-popup-add-to-cart-cancel>' + window.cmsTexts.cartAddFromAssortPopupCancel + '</button>\n' +
					              '        <button class="btn primary-bg-color" data-popup-add-to-cart-submit>' + window.cmsTexts.cartAddFormAssortPopupAddToCart + '</button>\n' +
					              '      </div>' +
					              '     </div>\n' +
					              '    </div>\n' +
					              '   </div>\n' +
					              '  </div>\n' +
					              '  </div>\n' +
					              ' </div>';
					document.body.insertAdjacentHTML('beforeend', modal);
				} else {
					let cartAddForm = target.closest('.cart-add__form');

					if (cartAddForm)
						global.naja.uiHandler.submitForm(cartAddForm);
				}
				e.preventDefault();
			} else if (target.dataset.addToCartQuantityPlus !== undefined) {
				let wrap = target.closest('[data-add-to-cart-quantity-wrap]');
				if (!wrap)
					wrap = target.closest('form');

				let input = wrap.querySelector('[data-add-to-cart-quantity-input]');
				let value = parseInt(input.value);
				let max   = input.dataset.max ? parseInt(input.dataset.max) : 999999;

				if (value < max) {
					input.value = value + 1;
					input.dispatchEvent(new Event('change'));
				} else {
					const tooltip = tippy(input, {
						theme  : 'info',
						content: window.cmsTexts.maximumQuantityOfThisProductInCart.replace('__QUANTITY__', max),
					});
					tooltip.show();
					setTimeout(() => {
						tooltip.destroy();
					}, 4500);
				}
			} else if (target.dataset.addToCartQuantityMinus !== undefined) {
				let wrap = target.closest('[data-add-to-cart-quantity-wrap]');
				if (!wrap)
					wrap = target.closest('form');

				let input        = wrap.querySelector('[data-add-to-cart-quantity-input]');
				let inputMinimum = input.dataset.minimumAmount || 1;
				let value        = parseInt(input.value);
				let min          = input.dataset.allowZero === 'true' ? 0 : inputMinimum;

				if (value > min) {
					input.value = value - 1;
					input.dispatchEvent(new Event('change'));
				}
			} else if (target.dataset.popupAddToCartCancel !== undefined) {
				let modal = target.closest('.modal.cart-add__popup');
				if (modal) {
					modal.previousElementSibling.remove();
					modal.remove();
				}
			} else if (target.dataset.popupAddToCartSubmit !== undefined) {
				const modal     = target.closest('.modal.cart-add__popup');
				const noteInput = modal.querySelector('.cart-add__note-popup-placeholder');
				if (noteInput) {
					const targetNoteInput = document.getElementById(noteInput.dataset.target);

					if (targetNoteInput) {
						targetNoteInput.value = noteInput.value;
						global.naja.uiHandler.submitForm(targetNoteInput.closest('.cart-add__form'));
					}
				} else if (popupTrigger) {
					let data     = {};
					let hasError = false;

					modal.querySelectorAll('input, select, textarea').forEach(el => {
						if (el.required && !el.value) {
							el.classList.add('has-error');
							hasError = true;
							return;
						} else {
							el.classList.remove('has-error');
						}

						if (el.getAttribute('type') === 'checkbox') {
							if (el.checked)
								data[el.name] = el.value;
						} else if (el.getAttribute('type') === 'select') {
							let option                                      = el.options[el.selectedIndex];
							data[option.dataset.id + '|' + el.dataset.name] = option.dataset.name;
						} else if (el.value) {
							data[el.name] = el.value;
						}
					});

					if (hasError) {
						return false;
					}

					let form = popupTrigger.closest('.cart-add__form');
					if (form) {
						if (data)
							form.querySelector('[name="otherData"]').value = JSON.stringify(data);

						global.naja.uiHandler.submitForm(form);
					}
				}

				modal.previousElementSibling.remove();
				modal.remove();
			}
		});

		document.addEventListener('keypress', e => {
			if (e.target.dataset.addToCartQuantityInput !== undefined) {
				if (e.which == 13) {
					e.preventDefault();
					e.stopImmediatePropagation();

					return false;
				}
			}
		});

		global.naja.addEventListener('success', (e) => {
			this.initCart();

			const cartItem = e.response.cartItem;
			const currency = e.response.currency;
			if (cartItem) {
				if (cartItem.quantity > 0) {
					let el = document.activeElement;

					if (el.dataset.inCartText) {
						let originText = el.innerHTML;
						el.innerHTML   = el.dataset.inCartText;
						el.classList.add('added');

						setTimeout(function () {
							el.innerHTML = originText;
							el.classList.remove('added');
						}, 5000);
					}
				}

				const wrap = document.querySelector('[data-cart-add-product="' + cartItem.productId + '"]');

				if (wrap) {
					const totalWithoutVat = wrap.querySelector('[data-cart-item-total-price-without-vat]');
					if (totalWithoutVat)
						totalWithoutVat.textContent =
							FormatMoney.format(cartItem.totalPriceWithoutVat, currency ? currency.decimal : null);

					const total = wrap.querySelector('[data-cart-item-total-price]');
					if (total)
						total.textContent =
							FormatMoney.format(cartItem.totalPrice, currency ? currency.decimal : null);
				}
			}
		});
	}

	// Odeslání změny quantity inputu v AddToCart a v košíku
	initCart() {
		document.querySelectorAll('[data-add-to-cart-quantity-input="instant"]:not(.init)').forEach((el) => {
			el.classList.add('init');
			el.addEventListener('change', e => {
				let form = e.target.form;
				global.naja.makeRequest('post', form.action, new FormData(form), {
					history: false,
				});
			});
		});
	}
}
