<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Invoice;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\Model\Entities\Invoice;
use EshopOrders\Model\EshopOrdersConfig;

class QuickEditForm extends BaseControl
{
	protected ?Invoice $invoice = null;

	public function __construct(
		?Invoice $invoice = null
	)
	{
		$this->invoice = $invoice;
	}

	public function render(): void
	{
		if (!$this->invoice) {
			return;
		}

		$this->template->render($this->getTemplateFile());
	}

	public function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();
		$form->setShowLangSwitcher(false);

		if (EshopOrdersConfig::load('orderForm.allowEditInvoiceDUZP', false)) {
			$form->addDatePicker('duzp', 'eshopOrders.orderDetail.invoiceDUZP')
				->setDefaultValue(new \DateTime());
		}

		if (EshopOrdersConfig::load('orderForm.allowInvoiceCustomerCustomNumber', false)) {
			$form->addText('customerCustomNumber', 'eshopOrders.orderDetail.customerCustomNumber');
		}

		if (EshopOrdersConfig::load('orderForm.allowEditInvoiceDueDate', false) && $this->invoice) {
			$form->addDatePicker('dueDate', 'eshopOrders.orderDetail.invoiceDueDate')
				->setNullable();
		}

		$form->addSubmit('save', 'default.save');

		if ($this->invoice) {
			if ($form->getComponent('duzp', false)) {
				$form->getComponent('duzp')->setDefaultValue($this->invoice->getDUZP());
			}

			if ($form->getComponent('dueDate', false)) {
				$form->getComponent('dueDate')->setDefaultValue($this->invoice->dueDate);
			}

			if ($form->getComponent('customerCustomNumber', false) && $this->invoice->invoiceData->customer) {
				$form->getComponent('customerCustomNumber')->setDefaultValue($this->invoice->invoiceData->customer->customNumber);
			}
		}

		$form->onSuccess[] = function(BaseForm $form, array $values): void {
			if (array_key_exists('dueDate', $values)) {
				$this->invoice->dueDate = $values['dueDate'];
			}

			$this->invoice->duzp = $values['duzp'];
			$this->em->persist($this->invoice);

			if ($this->invoice->invoiceData->customer) {
				$this->invoice->invoiceData->customer->customNumber = $values['customerCustomNumber'];
				$this->em->persist($this->invoice->invoiceData->customer);
			}

			$this->em->flush();

			$this->presenter->flashMessageSuccess('default.saved');
			$this->presenter->redrawControl('flashes');
		};

		return $form;
	}
}
