<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\Payment;

/**
 * @method Payment|object|null getReference($id)
 * @method Payment|null get($id)
 */
class Payments extends BaseEntityService
{
	protected $entityClass = Payment::class;

	/** @var array|null */
	protected ?array $cForSelectOption = null;

	public function getForSelectOption(): array
	{
		if ($this->cForSelectOption === null) {
			$this->cForSelectOption = $this->getEr()->findPairs([], 'name') ?: [];
		}

		return $this->cForSelectOption;
	}

	/**
	 * @return Payment[]
	 */
	public function getAll(): array
	{
		return $this->getEr()
			->createQueryBuilder('p', 'p.id')
			->getQuery()
			->getResult();
	}
}
