<?php declare(strict_types = 1);

namespace EshopOrders\DI;

use Core\DI\CompilerExtension;
use Nette;

class EshopOrdersExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));;

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['EshopOrders' => 'EshopOrders\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		try {
			/** @var Nette\DI\Definitions\ServiceDefinition $cartHelper */
			$cartHelper = $builder->getDefinition('eshopOrders.cartHelper');
			$cartHelper->addSetup(new Nette\DI\Definitions\Statement('$service->setOrderSales(?)', [$builder->getDefinition('eshopSales.front.orderSales')]));
		} catch (Nette\DI\MissingServiceException $exception) {
		}
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods['initialize'];
		$builder = $this->getContainerBuilder();

		$init->addBody('EshopOrders\Model\EshopOrdersConfig::setParams($this->parameters[\'eshopOrders\']);');
		$init->addBody('EshopOrders\Model\Helpers\FormValidator::$pscHelper = $this->getService(\'eshopOrders.helper.psc\');');
	}
}
