<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Order;

use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\FrontModule\Model\Speditions;
use EshopOrders\Model\Payments;

class PaySpedSummary extends BaseControl
{
	protected Carts      $cartsService;
	protected Speditions $speditionsService;
	protected Payments   $paymentsService;
	private ?int         $speditionId = null;
	private ?int         $paymentId   = null;
	private ?float       $priceTotal  = null;

	public function __construct(
		Carts      $carts,
		Speditions $speditions,
		Payments   $payments
	)
	{
		$this->cartsService      = $carts;
		$this->speditionsService = $speditions;
		$this->paymentsService   = $payments;
	}

	public function render(): void
	{
		$this->template->setFile($this->getTemplateFile());

		$this->template->paySpedCombination = $this->getSpeditionPaymentCombination($this->speditionId, $this->paymentId);
		$this->template->priceTotal         = $this->priceTotal;

		$this->template->render();
	}

	public function getSpeditionPaymentCombination(int $speditionId, int $paymentId): array
	{
		$spedition = $payment = null;
		if ($speditionId) {
			$spedition = $this->speditionsService->get($speditionId);
		}

		if ($paymentId) {
			$payment = $this->paymentsService->get($paymentId);
		}
		$cart      = $this->cartsService->getCurrentCart();
		$cartPrice = $cart->getPriceTotal();

		$text  = '';
		$price = 0;

		if ($spedition) {
			$text  .= $spedition->getName();
			$price += $spedition->getPriceActual($cart);
			if ($payment) {
				$text .= ', ';
			}
		}
		if ($payment) {
			$text  .= $payment->getName();
			$price += $payment->getPrice();
		}

		return ['text' => $text, 'price' => $price];
	}

	public function setParameters(int $speditionId, int $paymentId, float $priceTotal): void
	{
		$this->speditionId = $speditionId;
		$this->paymentId   = $paymentId;
		$this->priceTotal  = $priceTotal;
	}
}

