<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use EshopCatalog\FrontModule\Model\Dao\Product;

class CartItemGift
{
	protected int     $productId;
	protected Product $product;
	public ?string    $code1 = null;
	public ?string    $ean   = null;
	protected ?string $name  = null;

	public function __construct(
		Product $product,
		?string $name = null
	)
	{
		$this->product   = $product;
		$this->productId = $product->getId();
		$this->name      = $name ?: $product->getName();
		$this->code1     = $product->getCode1();
		$this->ean       = $product->getEan();
	}

	public function getProductId(): int { return $this->productId; }

	public function getName(): string { return $this->name; }
}
