<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use EshopOrders\Model\EshopOrdersConfig;
use EshopOrders\Model\Helpers\OrderItemReviewsHelper;
use Nette\Utils\DateTime;

class ProductReview
{
	public string   $customer;
	public DateTime $created;
	public float    $rating;
	public float    $maxRating;
	public ?string  $description = null;

	public function __construct(
		string   $customer,
		DateTime $created,
		float    $rating,
		?string  $description
	)
	{
		$this->customer    = $customer;
		$this->created     = DateTime::from($created);
		$this->rating      = $rating;
		$this->description = $description;
		$this->maxRating   = self::getMaxRating();
	}

	/**
	 * @return float[]
	 */
	public function getRatingAsArray(bool $withBlanks = false): array
	{
		return OrderItemReviewsHelper::ratingToArray($this->rating, $withBlanks);
	}

	public static function getMaxRating(): float
	{
		return (float) EshopOrdersConfig::load('orderItemReviews.maxRating');
	}
}
