<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Event;

use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderAddress;
use EshopOrders\Model\Entities\OrderPayment;
use EshopOrders\Model\Entities\OrderSpedition;
use Nette\Utils\ArrayHash;
use Symfony\Contracts\EventDispatcher\Event;

class OrderEvent extends Event
{
	public ?Order          $order          = null;
	public ?OrderAddress   $addrDelivery   = null;
	public ?OrderAddress   $addrInvoice    = null;
	public ?OrderSpedition $orderSpedition = null;
	public ?OrderPayment   $orderPayment   = null;
	public array           $orderItems     = [];

	/** @var array|ArrayHash */
	public $formData = [];

	public function __construct(
		Order $order
	)
	{
		$this->order = &$order;
	}
}
